package inc.monsters.mias.data.statistics;

import inc.monsters.mias.data.Kid;
import inc.monsters.mias.data.facade.KidService;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.apache.myfaces.trinidad.model.ChartModel;

public class AgeDistribution extends ChartModel {
	private static final Logger log = Logger.getLogger("inc.monsters.mias");
	
	private KidService kidService;

	private List<List<Double>> data;
	private List<Kid> kids;

	public KidService getKidService() {
		return kidService;
	}

	public void setKidService(KidService kidService) {
		this.kidService = kidService;
	}

	public List<Kid> getKids() {
		if(null == kids) {
			kids = kidService.getKids();
		}
		return kids;
	}

	private void calculate() {
		log.fine("calculate()");
		data = new ArrayList<List<Double>>();
		
		data.add(new ArrayList<Double>());
		for(int i = 0; i < 4; i++){ // kids in ages 0 - 11
			data.get(0).add(0.0);
		}
	
		for(Kid kid: getKids()) {
			int age = kid.getAge();
			
			double currentValue = data.get(0).get(age/3);
			data.get(0).set(age/3, currentValue + 1.0);
		}

		log.fine("bravenessData size: " + data.size());
		for(List<Double> list : data) {
			log.finer(" => " + list);
		}
	}
	
	@Override
	public List<String> getGroupLabels() {
		log.fine("getGroupLabels()");
		calculate();
		List<String> x = new ArrayList<String>();
		x.add("Age distribution");
		return x;
	}

	@Override
	public List<String> getSeriesLabels() {
		log.fine("getSeriesLabels()");
		calculate();
		calculate();
		List<String> x = new ArrayList<String>();
		x.add("Ages 0-2");
		x.add("Ages 3-5");
		x.add("Ages 6-8");
		x.add("Ages 9-11");
		return x;
	}

	@Override
	public List<List<Double>> getYValues() {
		log.fine("getYValues()");
		calculate();
		return data;
	}

	@Override
	public String getFootNote() {
		return super.getFootNote();
	}

	@Override
	public Double getMaxXValue() {
//		return 12.0;
		return super.getMaxXValue();
	}

	@Override
	public Double getMaxYValue() {
//		return 20.0;
		return super.getMaxYValue();
	}

	@Override
	public Double getMinXValue() {
		return 0.0;
//		return super.getMinXValue();
	}

	@Override
	public Double getMinYValue() {
		return 0.0;
//		return super.getMinYValue();
	}

	@Override
	public List<Color> getSeriesColors() {
		return super.getSeriesColors();
	}

	@Override
	public String getSubTitle() {
		return super.getSubTitle();
	}

	@Override
	public String getTitle() {
		return "Age distribution";
	}

	@Override
	public List<List<Double>> getXValues() {
		return super.getXValues();
	}
}